﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/


using GE.Visualisation;
using GE.Physics.Shapes;
using Microsoft.Xna.Framework;
using System.Collections.Generic;

namespace GE.World.Entities
{
    class SpriteElement
    {
        public int _iIdTexture;
        public int _iIdSprite;
        public List<Vector2> _v2Position;
    }

    /// <summary>
    /// Represent all the static entities of the level
    /// </summary>
    class LevelEntity : WorldEntity
    {
        /// <summary>
        /// List of the physic shapes representing the platforms
        /// </summary>
        StaticShapeRectangle[] _shapes;

        /// <summary>
        /// List containing the level's sprites
        /// </summary>
        List<SpriteElement> _spritesArray;

        /// <summary>
        /// Constructor
        /// </summary>
        public LevelEntity() : base()
        {
            _spritesArray = new List<SpriteElement>();
            _entityType = eEntityType.eEntityPlatform;
            _side = eSide.eSideNeutral;
        }

        public override void activate()
        {
            _bActive = true;
            
        }

        /// <summary>
        /// Add a sprite in the level
        /// </summary>
        /// <param name="idTexture"></param>
        /// <param name="spriteName"></param>
        /// <param name="position"></param>
        public void addSprite(int idTexture, string spriteName, Vector2 position)
        {
            //get the sprite id
            int spriteID = Visu.Instance.getSpriteId(idTexture, spriteName);

            //go through the elements
            foreach (SpriteElement e in _spritesArray)
            {
                if (idTexture == e._iIdTexture && spriteID == e._iIdSprite)
                {
                    e._v2Position.Add(position);
                    return;
                }
            }

            //the element doesn't exist so we add it
            SpriteElement newElement = new SpriteElement();
            newElement._iIdSprite = spriteID;
            newElement._iIdTexture = idTexture;
            newElement._v2Position = new List<Vector2>();
            newElement._v2Position.Add(position);
            _spritesArray.Add(newElement);
        }

        /// <summary>
        /// Add the array of shapes in the level
        /// </summary>
        /// <param name="shapeArray"></param>
        public void addShape(StaticShapeRectangle[] shapeArray)
        {
            _shapes = shapeArray;
            foreach (StaticShapeRectangle s in _shapes)
                Physics.Physics.Instance.addShape(s);
        }

        public override void render()
        {
            //go through each sprite element
            foreach (SpriteElement element in _spritesArray)
            {
                //go through each position
                foreach (Vector2 p in element._v2Position)
                {
                    Vector2 v2ScreenPosition = p - World.Instance.CameraPosition;
                    Visu.Instance.displaySprite(element._iIdTexture, element._iIdSprite, v2ScreenPosition);
                }
            }
            
        }
    }
}
